//
// Tee distributes a single message to 
// a collection of receivers.

#import <Foundation/Foundation.h>

#define MCTEE_CONN_SEQ	@"seq"
#define MCTEE_CONN_NAME	@"name"

@interface MCTee:NSObject
{
    NSMutableArray *outlets;
    NSMutableArray *stagedConnections;
}

+ (void)loggingOn;
+ (void)loggingOff;
+ (BOOL)isLoggingOn;

// GETTING THE LIST
- (NSMutableArray *)array;
- (NSArray *)allTargetObjects;	// More advanced recursive definition

// ADDING AN OUTLET TO THE Tee

- (void)addOutlet:(id)anOutlet;

// FORWARDING MESSAGES TO THE RECEIVER'S OUTLETS

- (BOOL)respondsToSelector:(SEL)aSelector;

// TYPED STREAM SUPPORT

- (id)initWithCoder:(NSCoder *)aDecoder;
- (void)encodeWithCoder:(NSCoder *)aCoder;

@end



